/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.corext.refactoring;

import org.asnlab.asndt.core.AsnConventions;
import org.asnlab.asndt.core.AsnCore;
import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IMember;
import org.asnlab.asndt.core.IType;
import org.asnlab.asndt.internal.corext.refactoring.RefactoringCoreMessages;
import org.asnlab.asndt.internal.corext.refactoring.changes.RenameResourceChange;
import org.asnlab.asndt.internal.corext.refactoring.util.ResourceUtil;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.asnlab.asndt.internal.corext.util.Messages;
import org.asnlab.asndt.internal.corext.util.Resources;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class Checks {
    public static final int IS_RVALUE = 0;
    public static final int NOT_RVALUE_MISC = 1;
    public static final int NOT_RVALUE_VOID = 2;

    private Checks() {
    }

    public static RefactoringStatus checkFieldName(String name) {
        return Checks.checkName(name, AsnConventions.validateFieldName((String)name));
    }

    public static RefactoringStatus checkTypeParameterName(String name) {
        return Checks.checkName(name, AsnConventions.validateTypeVariableName((String)name));
    }

    public static RefactoringStatus checkIdentifier(String name) {
        return Checks.checkName(name, AsnConventions.validateIdentifier((String)name));
    }

    public static RefactoringStatus checkMethodName(String name) {
        RefactoringStatus status = Checks.checkName(name, AsnConventions.validateMethodName((String)name));
        if (status.isOK() && Checks.startsWithUpperCase(name)) {
            return RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.Checks_method_names_lowercase);
        }
        return status;
    }

    public static RefactoringStatus checkCompilationUnitName(String name) {
        return Checks.checkName(name, AsnConventions.validateCompilationUnitName((String)name));
    }

    public static RefactoringStatus checkCompilationUnitNewName(ICompilationUnit cu, String newName) {
        String newCUName = AsnModelUtil.getRenamedCUName(cu, newName);
        if (Checks.resourceExists(RenameResourceChange.renamedResourcePath(ResourceUtil.getResource(cu).getFullPath(), newCUName))) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.Checks_cu_name_used, newName));
        }
        return new RefactoringStatus();
    }

    public static boolean startsWithUpperCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toUpperCase(s.charAt(0));
    }

    public static boolean startsWithLowerCase(String s) {
        if (s == null) {
            return false;
        }
        if ("".equals(s)) {
            return false;
        }
        return s.charAt(0) == Character.toLowerCase(s.charAt(0));
    }

    public static boolean resourceExists(IPath resourcePath) {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(resourcePath) != null;
    }

    public static boolean isAnonymous(IType type) throws AsnModelException {
        return type.isAnonymous();
    }

    public static boolean isAlreadyNamed(IAsnElement element, String name) {
        return name.equals(element.getElementName());
    }

    public static RefactoringStatus checkName(String name, IStatus status) {
        RefactoringStatus result = new RefactoringStatus();
        if ("".equals(name)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_Choose_name);
        }
        if (status.isOK()) {
            return result;
        }
        switch (status.getSeverity()) {
            case 4: {
                return RefactoringStatus.createFatalErrorStatus((String)status.getMessage());
            }
            case 2: {
                return RefactoringStatus.createWarningStatus((String)status.getMessage());
            }
            case 1: {
                return RefactoringStatus.createInfoStatus((String)status.getMessage());
            }
        }
        return new RefactoringStatus();
    }

    public static RefactoringStatus checkIfCuBroken(IMember member) throws AsnModelException {
        ICompilationUnit cu = (ICompilationUnit)AsnCore.create((IResource)ResourceUtil.getResource(member));
        if (cu == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_created);
        }
        if (!cu.isStructureKnown()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.Checks_cu_not_parsed);
        }
        return new RefactoringStatus();
    }

    public static void checkCompileErrorsInAffectedFile(RefactoringStatus result, IResource resource) throws AsnModelException {
        if (Checks.hasCompileErrors(resource)) {
            result.addWarning(Messages.format(RefactoringCoreMessages.Checks_cu_has_compile_errors, resource.getFullPath().makeRelative()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasCompileErrors(IResource resource) throws AsnModelException {
        try {
            IMarker[] problemMarkers = resource.findMarkers("org.asnlab.asndt.core.problem", true, 2);
            int i = 0;
            while (true) {
                if (i >= problemMarkers.length) {
                    return false;
                }
                if (problemMarkers[i].getAttribute("severity", -1) == 2) {
                    return true;
                }
                ++i;
            }
        }
        catch (AsnModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new AsnModelException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isReadOnly(IResource res) throws AsnModelException {
        ResourceAttributes attributes = res.getResourceAttributes();
        if (attributes != null && attributes.isReadOnly()) {
            return true;
        }
        if (!(res instanceof IContainer)) {
            return false;
        }
        IContainer container = (IContainer)res;
        try {
            IResource[] children = container.members();
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    return false;
                }
                if (Checks.isReadOnly(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (AsnModelException e) {
            throw e;
        }
        catch (CoreException e) {
            throw new AsnModelException(e);
        }
    }

    public static RefactoringStatus validateModifiesFiles(IFile[] filesToModify, Object context) {
        RefactoringStatus result = new RefactoringStatus();
        IStatus status = Resources.checkInSync((IResource[])filesToModify);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable((IResource[])filesToModify, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static RefactoringStatus validateEdit(ICompilationUnit unit, Object context) {
        IResource resource = unit.getPrimary().getResource();
        RefactoringStatus result = new RefactoringStatus();
        if (resource == null) {
            return result;
        }
        IStatus status = Resources.checkInSync(resource);
        if (!status.isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
        }
        if (!(status = Resources.makeCommittable(resource, context)).isOK()) {
            result.merge(RefactoringStatus.create((IStatus)status));
            if (!result.hasFatalError()) {
                result.addFatalError(RefactoringCoreMessages.Checks_validateEdit);
            }
        }
        return result;
    }

    public static RefactoringStatus checkAvailability(IAsnElement asnElement) throws AsnModelException {
        RefactoringStatus result = new RefactoringStatus();
        if (!asnElement.exists()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_not_in_model, asnElement.getElementName()));
        }
        if (asnElement.isReadOnly()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_read_only, asnElement.getElementName()));
        }
        if (asnElement.exists() && !asnElement.isStructureKnown()) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_unknown_structure, asnElement.getElementName()));
        }
        if (asnElement instanceof IMember) {
            result.addFatalError(Messages.format(RefactoringCoreMessages.Refactoring_binary, asnElement.getElementName()));
        }
        return result;
    }

    public static boolean isAvailable(IAsnElement asnElement) throws AsnModelException {
        if (asnElement == null) {
            return false;
        }
        if (!asnElement.exists()) {
            return false;
        }
        if (asnElement.isReadOnly()) {
            return false;
        }
        if (!(asnElement instanceof IAsnProject) && !asnElement.isStructureKnown()) {
            return false;
        }
        return !(asnElement instanceof IMember);
    }

    public static RefactoringStatus checkTempName(String newName) {
        RefactoringStatus result = Checks.checkIdentifier(newName);
        if (result.hasFatalError()) {
            return result;
        }
        if (!Checks.startsWithLowerCase(newName)) {
            result.addWarning(RefactoringCoreMessages.ExtractTempRefactoring_convention);
        }
        return result;
    }

    public static RefactoringStatus checkEnumConstantName(String newName) {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (result.hasFatalError()) {
            return result;
        }
        int i = 0;
        while (i < newName.length()) {
            char c = newName.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                result.addWarning(RefactoringCoreMessages.RenameEnumConstRefactoring_convention);
                break;
            }
            ++i;
        }
        return result;
    }

    public static RefactoringStatus checkConstantName(String newName) {
        RefactoringStatus result = Checks.checkFieldName(newName);
        if (result.hasFatalError()) {
            return result;
        }
        int i = 0;
        while (i < newName.length()) {
            char c = newName.charAt(i);
            if (Character.isLetter(c) && !Character.isUpperCase(c)) {
                result.addWarning(RefactoringCoreMessages.ExtractConstantRefactoring_convention);
                break;
            }
            ++i;
        }
        return result;
    }
}

