/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.dnd;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

public class AsndtViewerDropAdapter
implements DropTargetListener {
    public static final int LOCATION_NONE = 0;
    public static final int LOCATION_ON = 1;
    public static final int LOCATION_BEFORE = 2;
    public static final int LOCATION_AFTER = 4;
    private static final int LOCATION_EPSILON = 5;
    private static final int ITEM_MARGIN_LEFT = 40;
    private static final int ITEM_MARGIN_RIGTH = 10;
    public static final int INSERTION_FEEDBACK = 2;
    private StructuredViewer fViewer;
    private int fFeedback;
    private boolean fShowInsertionFeedback;
    private boolean fFullWidthMatchesItem;
    private int fRequestedOperation;
    private int fLastOperation;
    protected int fLocation;
    protected Object fTarget;

    public AsndtViewerDropAdapter(StructuredViewer viewer, int feedback) {
        Assert.isNotNull((Object)viewer);
        this.fViewer = viewer;
        this.fFeedback = feedback;
        this.fLastOperation = -1;
        this.fFullWidthMatchesItem = true;
    }

    public void showInsertionFeedback(boolean showInsertionFeedback) {
        this.fShowInsertionFeedback = showInsertionFeedback;
    }

    protected void setFullWidthMatchesItem(boolean enable) {
        this.fFullWidthMatchesItem = enable;
    }

    protected StructuredViewer getViewer() {
        return this.fViewer;
    }

    public void drop(DropTargetEvent event) {
        this.drop(this.fTarget, event);
    }

    public void drop(Object target, DropTargetEvent event) {
    }

    public void validateDrop(DropTargetEvent event) {
        this.validateDrop(this.fTarget, event, this.fRequestedOperation);
    }

    public void validateDrop(Object target, DropTargetEvent event, int operation) {
    }

    public void dragEnter(DropTargetEvent event) {
        this.dragOperationChanged(event);
    }

    public void dragLeave(DropTargetEvent event) {
        this.fTarget = null;
        this.fLocation = 0;
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.fRequestedOperation = event.detail;
        this.fTarget = this.computeTarget(event);
        this.fLocation = this.computeLocation(event);
        this.validateDrop(event);
        this.fLastOperation = event.detail;
        this.computeFeedback(event);
    }

    public void dragOver(DropTargetEvent event) {
        Object oldTarget = this.fTarget;
        this.fTarget = this.computeTarget(event);
        int oldLocation = this.fLocation;
        this.fLocation = this.computeLocation(event);
        if (oldLocation != this.fLocation || oldTarget != this.fTarget || this.fLastOperation != event.detail) {
            this.validateDrop(event);
            this.fLastOperation = event.detail;
        } else {
            event.detail = this.fLastOperation;
        }
        this.computeFeedback(event);
    }

    public void dropAccept(DropTargetEvent event) {
        this.fTarget = this.computeTarget(event);
        this.validateDrop(event);
        this.fLastOperation = event.detail;
    }

    protected Object computeTarget(DropTargetEvent event) {
        if (event.item == null) {
            return null;
        }
        if (!this.fFullWidthMatchesItem) {
            Point coordinates = this.fViewer.getControl().toControl(new Point(event.x, event.y));
            Rectangle bounds = this.getBounds((Item)event.item);
            if (coordinates.x < bounds.x - 40 || coordinates.x >= bounds.x + bounds.width + 10) {
                event.item = null;
                return null;
            }
        }
        return event.item.getData();
    }

    protected int computeLocation(DropTargetEvent event) {
        if (!(event.item instanceof Item)) {
            return 0;
        }
        Item item = (Item)event.item;
        Point coordinates = this.fViewer.getControl().toControl(new Point(event.x, event.y));
        Rectangle bounds = this.getBounds(item);
        if (bounds == null) {
            return 0;
        }
        if (coordinates.y - bounds.y < 5) {
            return 2;
        }
        if (bounds.y + bounds.height - coordinates.y < 5) {
            return 4;
        }
        return 1;
    }

    private Rectangle getBounds(Item item) {
        if (item instanceof TreeItem) {
            return ((TreeItem)item).getBounds();
        }
        if (item instanceof TableItem) {
            return ((TableItem)item).getBounds(0);
        }
        return null;
    }

    protected void computeFeedback(DropTargetEvent event) {
        event.feedback = !this.fShowInsertionFeedback && this.fLocation != 0 ? 1 : this.fLocation;
        event.feedback |= this.fFeedback;
    }

    protected void clearDropOperation(DropTargetEvent event) {
        event.detail = 0;
    }

    protected int getRequestedOperation() {
        return this.fRequestedOperation;
    }

    protected void setDefaultFeedback(int feedback) {
        this.fFeedback = feedback;
    }

    public void internalTestSetLocation(int location) {
        this.fLocation = location;
    }
}

