/*
 * Decompiled with CFR 0.152.
 */
package org.asnlab.asndt.internal.ui.refactoring.actions;

import org.asnlab.asndt.core.AsnModelException;
import org.asnlab.asndt.core.IAsnElement;
import org.asnlab.asndt.core.IAsnProject;
import org.asnlab.asndt.core.ICompilationUnit;
import org.asnlab.asndt.core.IComponentType;
import org.asnlab.asndt.core.ISourceFolder;
import org.asnlab.asndt.core.IType;
import org.asnlab.asndt.core.IValue;
import org.asnlab.asndt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.asnlab.asndt.internal.corext.util.AsnModelUtil;
import org.asnlab.asndt.internal.ui.AsnPlugin;
import org.asnlab.asndt.internal.ui.actions.ActionUtil;
import org.asnlab.asndt.internal.ui.actions.SelectionConverter;
import org.asnlab.asndt.internal.ui.asneditor.AsnTextSelection;
import org.asnlab.asndt.internal.ui.asneditor.CompilationUnitEditor;
import org.asnlab.asndt.internal.ui.refactoring.RefactoringMessages;
import org.asnlab.asndt.internal.ui.util.ExceptionHandler;
import org.asnlab.asndt.ui.actions.SelectionDispatchAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class RenameAsnElementAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public RenameAsnElementAction(IWorkbenchSite site) {
        super(site);
    }

    public RenameAsnElementAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            if (selection.size() == 1) {
                this.setEnabled(RenameAsnElementAction.canEnable(selection));
                return;
            }
        }
        catch (AsnModelException e) {
            if (AsnModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                AsnPlugin.log(e);
            }
        }
        catch (CoreException e) {
            AsnPlugin.log(e);
        }
        this.setEnabled(false);
    }

    private static boolean canEnable(IStructuredSelection selection) throws CoreException {
        IAsnElement element = RenameAsnElementAction.getAsnElement(selection);
        if (element == null) {
            return false;
        }
        return RenameAsnElementAction.isRenameAvailable(element);
    }

    private static IAsnElement getAsnElement(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IAsnElement)) {
            return null;
        }
        return (IAsnElement)first;
    }

    public void run(IStructuredSelection selection) {
        IAsnElement element = RenameAsnElementAction.getAsnElement(selection);
        if (element == null) {
            return;
        }
        try {
            this.run(element);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.RenameAsnElementAction_name, RefactoringMessages.RenameAsnElementAction_exception);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        block5: {
            if (selection instanceof AsnTextSelection) {
                try {
                    IAsnElement[] elements = ((AsnTextSelection)selection).resolveElementAtOffset();
                    if (elements.length == 1) {
                        this.setEnabled(RenameAsnElementAction.isRenameAvailable(elements[0]));
                        break block5;
                    }
                    this.setEnabled(false);
                }
                catch (CoreException coreException) {
                    this.setEnabled(false);
                }
            } else {
                this.setEnabled(true);
            }
        }
    }

    public void run(ITextSelection selection) {
        try {
            IAsnElement element = this.getAsnElement();
            if (element != null && RenameAsnElementAction.isRenameAvailable(element)) {
                this.run(element);
                return;
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.RenameAsnElementAction_name, RefactoringMessages.RenameAsnElementAction_exception);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.RenameAsnElementAction_name, (String)RefactoringMessages.RenameAsnElementAction_not_available);
    }

    public boolean canRun() {
        IAsnElement element;
        block5: {
            element = this.getAsnElement();
            if (element != null) break block5;
            return false;
        }
        try {
            return RenameAsnElementAction.isRenameAvailable(element);
        }
        catch (AsnModelException e) {
            if (AsnModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                AsnPlugin.log(e);
            }
        }
        catch (CoreException e) {
            AsnPlugin.log(e);
        }
        return false;
    }

    private IAsnElement getAsnElement() throws AsnModelException {
        IAsnElement[] elements = SelectionConverter.codeResolve(this.fEditor);
        if (elements == null || elements.length != 1) {
            return null;
        }
        return elements[0];
    }

    private void run(IAsnElement element) throws CoreException {
        if (!ActionUtil.isProcessable(this.getShell(), element)) {
            return;
        }
        if (ActionUtil.mustDisableAsnModelAction(this.getShell(), element)) {
            return;
        }
    }

    private static boolean isRenameAvailable(IAsnElement element) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return RefactoringAvailabilityTester.isRenameAvailable((IAsnProject)element);
            }
            case 4: {
                return RefactoringAvailabilityTester.isRenameAvailable((ISourceFolder)element);
            }
            case 5: {
                return RefactoringAvailabilityTester.isRenameAvailable((ICompilationUnit)element);
            }
            case 10: {
                return RefactoringAvailabilityTester.isRenameAvailable((IType)element);
            }
            case 11: {
                IValue value = (IValue)element;
                return RefactoringAvailabilityTester.isRenameAvailable(value);
            }
            case 15: {
                IComponentType field = (IComponentType)element;
                return RefactoringAvailabilityTester.isRenameFieldAvailable(field);
            }
        }
        return false;
    }
}

