/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.output;

import java.io.IOException;
import java.io.OutputStream;

public abstract class ThresholdingOutputStream
extends OutputStream {
    private /* synthetic */ boolean thresholdExceeded;
    private /* synthetic */ int threshold;
    private /* synthetic */ long written;

    public long getByteCount() {
        ThresholdingOutputStream a2;
        return a2.written;
    }

    public void write(byte[] a2, int a3, int a4) throws IOException {
        ThresholdingOutputStream a5;
        ThresholdingOutputStream thresholdingOutputStream = a5;
        thresholdingOutputStream.checkThreshold(a4);
        thresholdingOutputStream.getStream().write(a2, a3, a4);
        thresholdingOutputStream.written += (long)a4;
    }

    public void write(byte[] a2) throws IOException {
        ThresholdingOutputStream a3;
        a3.checkThreshold(a2.length);
        ThresholdingOutputStream thresholdingOutputStream = a3;
        thresholdingOutputStream.getStream().write(a2);
        thresholdingOutputStream.written += (long)a2.length;
    }

    public void write(int a2) throws IOException {
        ThresholdingOutputStream a3;
        ThresholdingOutputStream thresholdingOutputStream = a3;
        thresholdingOutputStream.checkThreshold(1);
        thresholdingOutputStream.getStream().write(a2);
        ++thresholdingOutputStream.written;
    }

    protected abstract void thresholdReached() throws IOException;

    public int getThreshold() {
        ThresholdingOutputStream a2;
        return a2.threshold;
    }

    protected abstract OutputStream getStream() throws IOException;

    public ThresholdingOutputStream(int a2) {
        ThresholdingOutputStream a3;
        a3.threshold = a2;
    }

    public void flush() throws IOException {
        ThresholdingOutputStream a2;
        a2.getStream().flush();
    }

    public boolean isThresholdExceeded() {
        ThresholdingOutputStream a2;
        return a2.written > (long)a2.threshold;
    }

    protected void checkThreshold(int a2) throws IOException {
        ThresholdingOutputStream a3;
        if (!a3.thresholdExceeded && a3.written + (long)a2 > (long)a3.threshold) {
            a3.thresholdReached();
            a3.thresholdExceeded = true;
        }
    }

    public static String K(String a2) {
        int n2 = a2.length();
        int n3 = n2 - 1;
        char[] cArray = new char[n2];
        int n4 = 4 << 4 ^ 5;
        int n5 = n3;
        char c2 = '\u0001';
        while (n5 >= 0) {
            int n6 = n3--;
            cArray[n6] = (char)(a2.charAt(n6) ^ c2);
            if (n3 < 0) break;
            int n7 = n3--;
            cArray[n7] = (char)(a2.charAt(n7) ^ n4);
            n5 = n3;
        }
        return new String(cArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws IOException {
        ThresholdingOutputStream thresholdingOutputStream;
        ThresholdingOutputStream a2;
        try {
            a2.flush();
            thresholdingOutputStream = a2;
        }
        catch (IOException iOException) {
            thresholdingOutputStream = a2;
        }
        thresholdingOutputStream.getStream().close();
    }
}

